// priority: 23

// 本脚本允许您为服务器中的特定维度设置复杂的进入条件。玩家必须满足您所设定的条件才能成功进入该维度。
// 条件可以基于以下三种类型，并可自由组合：
//   1. 游戏阶段 (KubeJS Stages): 玩家必须拥有指定的阶段。
//   2. 游戏进度 (Minecraft Advancements): 玩家必须完成指定的进度。
//   3. 生物击杀: 玩家个人或整个服务器需要达到指定的生物击杀数量。
//
//
// ## 如何配置 ##
// 所有的配置都在下方的 `维度进入限制配置` 对象中完成。
//
// ### 1. 调试模式开关 ###
// 在配置区上方有一个 `开启调试日志` 变量，将其设置为 `true` 可以在服务器后台或日志文件中看到详细的事件触发和判断流程，
// 便于排查问题。在确认脚本工作正常后，建议将其设置为 `false` 以保持后台清洁。
//
// ### 2. 顶层键 (维度ID) ###
// `维度进入限制配置` 对象的每一个键都是一个字符串，代表您想限制的维度的ID。
//   - 示例: `"minecraft:the_nether"`, `"twilightforest:twilight_forest"`
//   - 如何找到维度ID?
//     - 在游戏中输入指令 `/execute in` 然后按Tab键，可以查看并补全已加载的维度。
//     - 查阅相关模组的文档。
//
// ### 3. 规则对象 (维度的具体限制) ###
// 每个维度ID都对应一个规则对象，其中包含以下可配置的键：
//
//   - "提示信息_未满足": (字符串)
//     当玩家不满足进入条件时，会收到的提示信息。支持颜色代码 (如 §c, §b)。
//     示例: `"§c你尚未获得进入此地的资格。"`
//
//   - "提示信息_满足击杀条件": (字符串, 可选)
//     当玩家的某次击杀，正好满足了本规则中 "所需击杀列表" 的所有要求时，会向该玩家发送这条一次性的祝贺/提示信息。
//     对于"全服"范围的击杀，此消息会发给完成最后一杀的玩家。
//     如果不想发送，可以不写这个键。
//     示例: `"§a你感受到了来自深渊的回应..."`
//
//   - "逻辑类型": (字符串)
//     决定如何判断多个条件。可选值：
//       - "与": 玩家必须同时满足所有指定的"阶段"、"进度"和"击杀"条件。
//       - "或": 玩家只需满足"阶段"、"进度"、"击杀"三种条件中的任意一种即可。
//       - "仅阶段": 只检查 "所需阶段列表" 是否满足。
//       - "仅进度": 只检查 "所需进度列表" 是否满足。
//       - "仅击杀": 只检查 "所需击杀列表" 是否满足。
//
//   - "所需阶段列表": (字符串数组, 可选)
//     一个包含阶段ID的数组。玩家必须拥有此列表中的所有阶段。
//     阶段ID即为您在KubeJS Stages中定义的名称。
//     示例: `["探索者", "已击败凋零"]`
//
//   - "所需进度列表": (字符串数组, 可选)
//     一个包含进度ID的数组。玩家必须完成此列表中的所有进度。
//     如何找到进度ID？按F3+H开启高级提示框，在进度界面将鼠标悬停在进度上即可看到。
//     示例: `["minecraft:story/mine_diamond", "minecraft:nether/find_fortress"]`
//
//   - "所需击杀列表": (对象, 可选)
//     一个记录"生物ID": 需要数量的对象。
//     如何找到生物ID？使用 `/summon` 指令可以查看。
//     示例: `{ "minecraft:wither": 1, "minecraft:ender_dragon": 5 }`
//
//   - "击杀条件范围": (字符串, 可选)
//     仅当 "所需击杀列表" 存在时有效。决定击杀计数是针对个人还是全服。
//       - "个人": 每个玩家的击杀数独立计算。玩家A的击杀不影响玩家B。
//       - "全服": 所有玩家的击杀数都会累加到服务器的总计数中。任何人完成都算作完成。
//     示例: `"个人"` 或 `"全服"

let 维度进入限制配置 = {
    "twilightforest:twilight_forest": {
        "提示信息_未满足": "§2神秘的森林拒绝了你。你需要 §b获得钻石套装 §c才能继续前进。",
        "逻辑类型": "仅进度",
        "所需进度列表": ["minecraft:diamond_armor"], // 钻石套装
    },
/*
    "minecraft:the_nether": {
    },
*/
    "minecraft:the_end": {
        "提示信息_未满足": "§5通往末地的道路被强大的能量封锁。§6亲手击杀焰魔,咒翼灵骸以及宰相。",
        "提示信息_满足击杀条件": "§5末地的最终通道已打开...",
        "逻辑类型": "或",
        "所需击杀列表": { "cataclysm:ignis": 1, "cataclysm:maledictus": 1, "goety:vizier": 1 },
        "击杀条件范围": "个人"
    },

    "deeperdarker:otherside": {
        "提示信息_未满足": "§c深邃的黑暗中传来一股抗拒的力量... 似乎需要整个服务器的力量献祭一名强大的存在(全服击杀: 监守者)。",
        "提示信息_满足击杀条件": "§c随着监守者的倒下，你感到通往彼岸的道路松动了！",
        "逻辑类型": "仅击杀",
        "所需击杀列表": { "minecraft:warden": 1 },
        "击杀条件范围": "全服"
    }
};